define(function () {

    var component = {
        inject: ["configuration"],
        data: function () {
            return {
                showMoreNewsToggle: true
            };
        },
        methods: {
            showMoreNews: function () {
                var _this = this;
                this.getItems(parseInt(this.webpartProperties.moreNews) +
                    parseInt(this.webpartProperties.numberOfNews)).then(function () {
                    _this.showMoreNewsToggle = !_this.showMoreNewsToggle;
                });
            },
            showLessNews: function () {
                var _this = this;
                this.getItems(this.webpartProperties.numberOfNews).then(function () {
                    _this.showMoreNewsToggle = !_this.showMoreNewsToggle;
                });
            }
        }
    };

    component.originalTemplate = "corpViewModern.oneColumn";
    component.template = `
<wizdomWebpart data-v-64eacfb3
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Corporate News' | translate"
  @titleChanged="webpartProperties.title = $event"
  :webpartPadding="true"
  chromeType="title"
  @webpart-resize="webpartResize"
>
  <div data-v-64eacfb3 v-if="items.length > 0">
    <div data-v-64eacfb3 class="news-items">
      <div data-v-64eacfb3 class="news-item-wrapper" v-for="item in items" :key="item.date">
        <div data-v-64eacfb3 class="news-item">
          <div data-v-64eacfb3 class="leftSection">
            <div data-v-64eacfb3 class="imageContainer">
              <a data-v-64eacfb3 :href="item.path" target="_blank" class="image-link">
                <div data-v-64eacfb3 class="image-image" :style="getStyle(item)">
                  <div data-v-64eacfb3
                    v-if="item.breaking && webpartProperties.breakingTag"
                    class="breaking"
                  >{{webpartProperties.breakingTagText}}</div>
                </div>
              </a>
            </div>
          </div>
          <div data-v-64eacfb3 class="rightSection">
            <div data-v-64eacfb3 id="content" class="content">
              <a data-v-64eacfb3 :href="item.path" target="_blank" class="text-link">
                <tags data-v-64eacfb3
                  v-if="item.listOfTags"
                  :tags="item.listOfTags"
                  :sizenow="sizenow"
                  ref="tags"
                ></tags>
                <div data-v-64eacfb3 class="titleAndDescription">
                  <div data-v-64eacfb3 class="title" :title="item.title">{{item.title}}</div>
                  <span data-v-64eacfb3
                    v-if="item.summary.length !== 0"
                    class="content-text"
                    v-html="item.summary"
                  ></span>
                  <span data-v-64eacfb3 v-else class="content-text" v-html="item.content"></span>
                </div>

                <div data-v-64eacfb3 class="authorNameEtc">
                  <div data-v-64eacfb3 v-show="item.loginName" class="authorAvatar">
                    <img data-v-64eacfb3
                      class="authorAvatar"
                      :src="'/_layouts/15/userphoto.aspx?size=S&username=' + item.loginName"
                    />
                  </div>
                  <div data-v-64eacfb3 class="author">{{item.author}}</div>
                  <span data-v-64eacfb3 v-show="item.date" class="timeago">
                    <uiIconClock data-v-64eacfb3 />
                    <timeago data-v-64eacfb3 :since="item.date" locale="lang">></timeago>
                  </span>
                  <views data-v-64eacfb3 v-if="webpartProperties.showViewCount" :views="item.views" class="views"></views>
                </div>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div data-v-64eacfb3 v-if="webpartProperties.moreNews > 0" class="show-more pointer">
      <span data-v-64eacfb3 v-if="showMoreNewsToggle" @click="showMoreNews()">
        {{'Show more'| translate}}
        <uiIconChevronDownMed data-v-64eacfb3 class="show-more-icon" />
      </span>
      <span data-v-64eacfb3 v-else @click="showLessNews()">
        {{'Show less'| translate}}
        <uiIconChevronUpMed data-v-64eacfb3 class="show-more-icon" />
      </span>
    </div>
  </div>
  <noItem data-v-64eacfb3
    v-if="!items.length && webpartProperties.contentPlaceholder"
    :title="contentPlaceholder.title"
    :theme="false"
    :illustration="'coffee'"
  ></noItem>
</wizdomWebpart>
`;
    component.styles = `
.pointer[data-v-64eacfb3] {
  cursor: pointer;
}
.summaryfix[data-v-64eacfb3] {
  font-size: 14px;
  line-height: 20px;
  margin-top: 5px;
  display: block;
  text-overflow: ellipsis;
  color: "[theme:neutralPrimaryAlt, default: #333]";
  max-height: 21px;
  white-space: nowrap;
  overflow: hidden;
  width: 100%;
}
.breaking[data-v-64eacfb3] {
  color: "[theme:white, default:#fff]";
  background-color: "[theme:accent, default:#0078d4]";
  position: absolute;
  top: 20px;
  left: 0;
  z-index: 1;
  text-align: center;
  padding: 5px 10px 5px 10px;
}
.news-items .news-item-wrapper[data-v-64eacfb3] {
  color: "[theme:bodyText, default: #333]";
  display: inline-block;
  box-sizing: border-box;
  width: 100%;
  border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
}
.news-items .news-item-wrapper .news-item[data-v-64eacfb3] {
    padding-bottom: 20px;
    padding-top: 20px;
    padding-left: 0;
    padding-right: 0;
    box-sizing: border-box;
    position: relative;
    color: "[theme:bodyText, default: #333]";
    display: table;
}
.news-items .news-item-wrapper .news-item .leftSection[data-v-64eacfb3] {
      display: table-cell;
      vertical-align: top;
}
.news-items .news-item-wrapper .news-item .rightSection[data-v-64eacfb3] {
      display: table-cell;
      vertical-align: top;
}
.news-items .news-item-wrapper .news-item .imageContainer[data-v-64eacfb3] {
      box-sizing: border-box;
      width: 274px;
      height: 154px;
      border: 1px solid "[theme:neutralLight, default:#eaeaea]";
      background-color: "[theme:neutralLighterAlt, default:#eaeaea]";
      box-sizing: border-box;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link[data-v-64eacfb3] {
        text-decoration: none;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link .image-image[data-v-64eacfb3] {
          height: 100%;
          width: 100%;
          position: relative;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link .image-image img[data-v-64eacfb3] {
            display: block;
            opacity: 1;
            width: 100%;
            height: auto;
            position: absolute;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
}
.news-items .news-item-wrapper .news-item .content[data-v-64eacfb3] {
      margin-left: 15px;
      height: 154px;
      box-sizing: border-box;
      overflow: hidden;
      color: "[theme:bodyText, default: #333]";
}
.news-items .news-item-wrapper .news-item .content[data-v-64eacfb3] .tag-container {
        margin-bottom: 11px;
}
.news-items .news-item-wrapper .news-item .content .titleAndDescription[data-v-64eacfb3] {
        height: 117px;
}
.news-items .news-item-wrapper .news-item .content .title[data-v-64eacfb3] {
        margin: -5px 0 0 0;
        padding: 0;
        font-size: 21px;
        font-weight: 300;
        line-height: 27px;
        text-overflow: ellipsis;
        display: block;
        position: relative;
        max-height: 54px;
        overflow: hidden;
        color: "[theme:themePrimary, default: #0078d4]";
}
.news-items .news-item-wrapper .news-item .content .content-text[data-v-64eacfb3] {
        font-size: 14px;
        line-height: 20px;
        margin-top: 5px;
        display: block;
        text-overflow: ellipsis;
        color: "[theme:neutralPrimaryAlt, default: #333]";
        max-height: 42px;
        overflow: hidden;
}
.news-items .news-item-wrapper .news-item .content .authorAvatar[data-v-64eacfb3] {
        display: inline-block;
        vertical-align: top;
        float: left;
        padding-right: 5px;
}
.news-items .news-item-wrapper .news-item .content .authorAvatar img[data-v-64eacfb3] {
          width: 32px;
          height: 32px;
          border-radius: 50%;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc[data-v-64eacfb3] {
        display: inline-block;
        font-size: 12px;
        vertical-align: top;
        position: absolute;
        bottom: 20px;
        width: 100%;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .author[data-v-64eacfb3] {
          margin-bottom: 2px;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .timeago[data-v-64eacfb3] {
          color: "[theme:neutralPrimaryAlt, default: #333]";
          margin-right: 5px;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .timeago i[data-v-64eacfb3] {
            position: relative;
            top: 1px;
            margin-right: 2px;
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .views[data-v-64eacfb3] {
          display: inline-block;
          color: "[theme:neutralPrimaryAlt, default: #333]";
}
.news-items .news-item-wrapper .news-item .content .authorNameEtc .views i[data-v-64eacfb3] {
            position: relative;
            top: 1px;
            margin-right: 1px;
}
.news-items .news-item-wrapper:first-child .news-item[data-v-64eacfb3] {
  padding-top: 0;
}
.news-items .news-item-wrapper[data-v-64eacfb3]:last-child {
  border-bottom: 0px;
}
a[data-v-64eacfb3] {
  text-decoration: none;
}
.text-link[data-v-64eacfb3] {
  color: "[theme:bodyText, default: #333]";
}
.show-more[data-v-64eacfb3] {
  padding-right: 16px;
  padding-bottom: 10px;
  color: "[theme:bodyText, default: #333]";
  float: right;
}
.show-more .show-more-icon[data-v-64eacfb3] {
    vertical-align: sub;
    color: "[theme:themePrimary, default:#0078d4]";
}

/* Styles for medium sized column */
.webpart-size-medium .news-items .news-item-wrapper .news-item .imageContainer[data-v-64eacfb3] {
  width: 194px;
  height: 110px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .breaking[data-v-64eacfb3] {
  padding: 1px 8px 2px 8px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content[data-v-64eacfb3] {
  height: 110px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .titleAndDescription[data-v-64eacfb3] {
    height: 20px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .content-text[data-v-64eacfb3] {
    max-height: 30px;
    line-height: 14px;
    margin-top: 0px;
    font-size: 12px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .title[data-v-64eacfb3] {
    font-size: 17px;
    line-height: 21px;
    max-height: 21px;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .authorAvatar[data-v-64eacfb3] {
    display: none;
}
.webpart-size-medium .news-items .news-item-wrapper .news-item .content .authorNameEtc[data-v-64eacfb3] {
    margin: 0;
}

/* Styles for small sized column */
.webpart-size-small .news-items .news-item-wrapper .news-item .imageContainer[data-v-64eacfb3] {
  width: 126px;
  height: 94px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .breaking[data-v-64eacfb3] {
  padding: 0px 4px 1px 4px;
  font-size: 13px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content[data-v-64eacfb3] {
  height: 94px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .titleAndDescription[data-v-64eacfb3] {
    height: 60px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .content-text[data-v-64eacfb3] {
    max-height: 19px;
    line-height: 9px;
    font-size: 10px;
    margin-top: 0px;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .title[data-v-64eacfb3] {
    font-size: 14px;
    line-height: 19px;
    max-height: 19px;
    font-weight: 400;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .authorAvatar[data-v-64eacfb3] {
    display: none;
}
.webpart-size-small .news-items .news-item-wrapper .news-item .content .authorNameEtc[data-v-64eacfb3] {
    margin: 0;
}


`;

    return component;

});
